%define osname		centos
%define osversion	5

Name: vztmpl-%{osname}-%{osversion}
Version: 2.0
Release: 2
Summary: OpenVZ template metadata for %{osname}-%{osversion} %{_arch}.
License: GPL
Vendor: SWsoft
URL:	http://openvz.org/
Group: Applications/System
Source: %{name}.src.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: createrepo, rpm-build, sed, gawk
Requires: vzpkg >= 2.7.0-18
Requires: vzrpm43, vzrpm43-python

%description
OpenVZ template metadata for %{osname}-%{osversion} %{_arch}.

%prep
%setup -n %{osname}-%{osversion} -q

%build
make

%install
make DESTDIR=%buildroot install

%files
%defattr(-, root, root)
%dir /vz/template/*/*/*/*
/vz/template/*/*/*/*/*
/vz/template/*/*/*/config/.rpmmacros

%clean
test "x$RPM_BUILD_ROOT" != "x" && rm -rf $RPM_BUILD_ROOT

%post
%ifarch i386
# Upgrade of old template (noarch) to i386 template
# Let's move yum cache to a new location.
mv -f /vz/template/%{osname}/%{osversion}/yum-cache/* \
	/vz/template/%{osname}/%{osversion}/i386/yum-cache/ >/dev/null 2>&1
# Now remove yum-cache directory
rm -rf /vz/template/%{osname}/%{osversion}/yum-cache
%endif
exit 0

%changelog
* Wed Dec 14 2005 Kir Kolyshkin <kir-at-openvz.org> 2.0-2
- removed anacron, added vixie-cron to default.list (bug #73)
- fixed download URLs in yum.conf (bug #77)
- added provides: kernel-drm to dummy package (bug #74)
- upgrade, not install dummy package (bug #78)

* Mon Oct 10 2005 Kir Kolyshkin <kir-at-openvz.org> 2.0-1
- added support for mulitple architectures
- added vzrpm requirement and config/rpm file
- added config/.rpmmacros to not install locales
- added minimal.list
- changed name to OpenVZ
- dev package renamed to vzdev to not trigger udev installation (bug #50)

* Sat Aug  6 2005 Kir Kolyshkin <kir-at-openvz.org> 1.0-5
- added /etc/mtab -> /proc/mounts link creation in install-post

* Fri Jul 29 2005 Kir Kolyshkin <kir-at-openvz.org> 1.0-4
- create yum-cache directory to workaround yum-2.2 bug (bug #12)

* Tue Jul 19 2005 Kir Kolyshkin <kir-at-openvz.org> 1.0-2
- fixed source tarball to be tar.bz2
- removed swsoft suffix from %release
- added dist target to Makefile

* Mon Jun 20 2005 Kir Kolyshkin <kir-at-openvz.org> 1.0-1.swsoft
- initial packaging
