<?
// RETURN LIST:
// --- 99: Error with connection (socket)
// --- 98: Server not speaking our language
// --- 
// ---  0: It's all OK

require './config.php';

function connectRoboStart () {
	global $robo, $socket;
	$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
	if ($socket === false) {
		echo "socket_create() failed: reason: " . socket_strerror(socket_last_error()) . "\n";
	}
	
	$result = socket_connect($socket, $robo['host'], $robo['port']);
	
	if ($result == false) {
		return 99;
	}
	
	// Send the IDENT
	$send = "IDENT ${robo['ident']}";
	socket_write($socket, $send, strlen($send));
	
	// Recieve the response:
	$bytes = socket_recv($socket, $buffer, 2048, 0);
	if (substr($buffer,0,5) == "HELLO") {
		// The response is valid
		$continue = 1;
	} else {
		// unknown response
		$continue = 0;
	}
	
	if ($continue == 0) {
		socket_close($socket);
		return 98;
	}

	// Recieve our HELO
	$bytes = socket_recv($socket, $buf, 2048, 0);
	if ($bytes == 0) {
		socket_close($socket);
		return;
	}

	$command = substr($buf, 0, 5);
	$options = substr($buf, 6, strlen($buf));

	if ($command == "START") {
		return 0;
	} else {
		return 98;
	}
}

// --- RoboStatus ($id)
// - Return a text-status of what the machine is doing.
function RoboStatus ($roboID) {
	global $socket;

	$send = "STATS $roboID";
	socket_write($socket, $send, strlen($send));

	// Wait and Return a response
	while (true) {
		$bytes = socket_recv($socket, $buf, 2048, 0);
		if ($bytes == 0) {
			socket_close($socket);
			return;
		}
	
		$command = substr($buf, 0, 5);
		$options = substr($buf, 6, strlen($buf));

		return "$options";
	}
}

?> 
